<?php $__env->startSection('panel'); ?>
<?php echo $__env->make('admin.components.tabs.product', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Product Name'); ?></th>
                                <th><?php echo app('translator')->get('Category'); ?></th>
                                <th><?php echo app('translator')->get('Author'); ?></th>
                                <th><?php echo app('translator')->get('Image'); ?></th>
                                <th><?php echo app('translator')->get('Price'); ?></th>
                                <th><?php echo app('translator')->get('Discount Price'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                           <?php $__empty_1 = true; $__currentLoopData = $pendingProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                           <tr>
                              <td><?php echo e(__($item->name)); ?></td>
                              <td><?php echo e(__($item->category->name)); ?></td>
                              <td>
                                <?php if($item->user): ?>
                                <span class="bage badge--warning"><?php echo e(__($item->user->username)); ?></span>
                                <?php else: ?>
                                <span class="bage badge--primary"><?php echo app('translator')->get('Admin'); ?></span>
                                <?php endif; ?>
                              </td>
                              <td><img src="<?php echo e(getImage(getFilePath('productThumbnail').'/'.@$item->thumbnail)); ?>" alt="Image" class="rounded" style="width:50px;"></td>

                              <td>
                                <?php echo e(__($general->cur_sym)); ?> <?php echo e(__(showAmount($item->price))); ?>

                            </td>
                            <td> <?php if(isset($item->discount)): ?>
                                 <?php echo e(__($item->discount)); ?>%
                                 <?php else: ?>
                                 <span><?php echo app('translator')->get('No'); ?></span>
                                 <?php endif; ?>
                            </td>
                                <td><?php echo $item->statusBadge($item->status); ?></td>
                              <td>
                                 <div class="button--group">
                                    <a href="<?php echo e(route('admin.product.single.approve',$item->id)); ?>"  class="btn btn-sm btn--warning" title="Approve"><i class="las la-check"></i></a>
                                    <a href="<?php echo e(route('admin.product.edit',$item->id)); ?>"  class="btn btn-sm btn--primary" title="Edit"><i class="las la-edit"></i></a>
                                    <button class="btn btn-sm btn--danger rejectBtn" data-id="<?php echo e($item->id); ?>" title="Delete"><i class="las la-trash"></i></button>
                                 </div>
                              </td>
                           </tr>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                           <tr>
                             <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                          </tr>
                           <?php endif; ?>
                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            <?php if($pendingProducts->hasPages()): ?>
            <div class="card-footer py-4">
                <?php echo e(paginateLinks($pendingProducts)); ?>

            </div>
            <?php endif; ?>
        </div><!-- card end -->
    </div>
</div>


<div id="rejectModal" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><?php echo app('translator')->get('Product Delete Confirmation'); ?></h5>
                <button type="button" class="close btn btn--danger" data-bs-dismiss="modal" aria-label="Close">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('admin.product.delete')); ?>" method="get">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <p><?php echo app('translator')->get('Are you sure you want to delete this product?'); ?>
                     </p>
                </div>
                <div class="modal-footer">
                    <div class="buttorn_wrapper">
                        <button type="submit" class="btn btn--success"> <span
                                class="btn_title"><?php echo app('translator')->get('Delete'); ?> <i
                                    class="fa-solid fa-angles-right"></i></span></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
<a href="<?php echo e(route('admin.product.index')); ?>" class="btn btn-sm btn--primary "><i class="la la-undo"></i> <?php echo app('translator')->get('Back'); ?></a>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function($){
        "use strict";
        $('.rejectBtn').on('click', function () {
            var modal = $('#rejectModal');
            modal.find('input[name=id]').val($(this).data('id'));
            modal.modal('show');
        });

    })(jQuery);
</script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fosterfarms/public_html/application/resources/views/admin/products/pendings.blade.php ENDPATH**/ ?>