<?php $__env->startSection('content'); ?>
<?php
if(isset($product->discount)){
    $discountAmount = $product->price -($product->price * $product->discount /100);
}

?>
<div class="col-xl-9 col-lg-12">
    <div class="dashboard-body account-form">
        <div class="dashboard-body__bar">
            <span class="dashboard-body__bar-icon"><i class="las la-bars"></i></span>
        </div>
        <div class="row gy-4 justify-content-center">
            <h3 class="contact__title"><?php echo e($pageTitle); ?></h3>

            <form action="<?php echo e(route('user.product.place')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="method_code">
                <input type="hidden" name="currency">
                <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                       <div class="row gy-md gy-3">
                            <div class="col-sm-12">
                                <label class="form--label"><?php echo app('translator')->get('Select Gateway'); ?></label>
                                <select class="select form-control form--control" name="gateway" required>
                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                    <option value="balance"><?php echo app('translator')->get('Account Balance'); ?> <?php echo e($general->cur_sym); ?><?php echo e(showAmount(auth()->user()->balance)); ?></option>
                                    <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($data->method_code); ?>" <?php if(old('gateway')==$data->method_code): echo 'selected'; endif; ?>
                                        data-gateway="<?php echo e($data); ?>"><?php echo e($data->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-sm-12">
                                <label class="form--label"><?php echo app('translator')->get('Amount'); ?></label>
                                <div class="input-group country-code">
                                    <span class="input-group-text"><?php echo e($general->cur_text); ?></span>

                                    <?php if(isset($product->discount)): ?>
                                        <input type="number" step="any" name="amount" class="form-control form--control"
                                        value="<?php echo e($discountAmount); ?>" autocomplete="off" readonly>
                                    <?php else: ?>
                                        <input type="number" step="any" name="amount" class="form-control form--control"
                                        value="<?php echo e($product->price); ?>" autocomplete="off" readonly>
                                    <?php endif; ?>

                                </div>
                            </div>
                       </div>

                        <div class="mt-3 preview-details d-none">
                            <span><?php echo app('translator')->get('Limit'); ?></span>
                            <span><span class="min fw-bold">0</span> <?php echo e(__($general->cur_text)); ?> - <span
                                    class="max fw-bold">0</span> <?php echo e(__($general->cur_text)); ?> , </span>
                            <span><?php echo app('translator')->get('Charge'); ?></span>
                            <span><span class="charge fw-bold">0</span> <?php echo e(__($general->cur_text)); ?> ,</span>
                            <span><?php echo app('translator')->get('Payable'); ?></span> <span><span class="payable fw-bold"> 0</span>
                                <?php echo e(__($general->cur_text)); ?> </span>
                        </div>
                        <button type="submit" class="btn btn--base mt-3"><?php echo app('translator')->get('Submit'); ?></button>
            </form>

    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    (function ($) {
        "use strict";
        $('select[name=gateway]').change(function () {
            if (!$('select[name=gateway]').val()) {
                $('.preview-details').addClass('d-none');
                return false;
            }
            var resource = $('select[name=gateway] option:selected').data('gateway');
            var fixed_charge = parseFloat(resource.fixed_charge);
            var percent_charge = parseFloat(resource.percent_charge);
            var rate = parseFloat(resource.rate)
            if (resource.method.crypto == 1) {
                var toFixedDigit = 8;
                $('.crypto_currency').removeClass('d-none');
            } else {
                var toFixedDigit = 2;
                $('.crypto_currency').addClass('d-none');
            }
            $('.min').text(parseFloat(resource.min_amount).toFixed(2));
            $('.max').text(parseFloat(resource.max_amount).toFixed(2));
            var amount = parseFloat($('input[name=amount]').val());
            if (!amount) {
                amount = 0;
            }
            if (amount <= 0) {
                $('.preview-details').addClass('d-none');
                return false;
            }
            $('.preview-details').removeClass('d-none');
            var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
            $('.charge').text(charge);
            var payable = parseFloat((parseFloat(amount) + parseFloat(charge))).toFixed(2);
            $('.payable').text(payable);
            var final_amo = (parseFloat((parseFloat(amount) + parseFloat(charge))) * rate).toFixed(toFixedDigit);
            $('.final_amo').text(final_amo);
            if (resource.currency != '<?php echo e($general->cur_text); ?>') {
                var rateElement = `<span class="fw-bold"><?php echo app('translator')->get('Conversion Rate'); ?></span> <span><span  class="fw-bold">1 <?php echo e(__($general->cur_text)); ?> = <span class="rate">${rate}</span>  <span class="base-currency">${resource.currency}</span></span></span>`;
                $('.rate-element').html(rateElement)
                $('.rate-element').removeClass('d-none');
                $('.in-site-cur').removeClass('d-none');
                $('.rate-element').addClass('d-flex');
                $('.in-site-cur').addClass('d-flex');
            } else {
                $('.rate-element').html('')
                $('.rate-element').addClass('d-none');
                $('.in-site-cur').addClass('d-none');
                $('.rate-element').removeClass('d-flex');
                $('.in-site-cur').removeClass('d-flex');
            }
            $('.base-currency').text(resource.currency);
            $('.method_currency').text(resource.currency);
            $('input[name=currency]').val(resource.currency);
            $('input[name=method_code]').val(resource.method_code);
            $('input[name=amount]').on('input');
        });
        $('input[name=amount]').on('input', function () {
            $('select[name=gateway]').change();
            $('.amount').text(parseFloat($(this).val()).toFixed(2));
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fosterfarms/public_html/application/resources/views/presets/default/user/payment/product_payment.blade.php ENDPATH**/ ?>