<?php $__env->startSection('panel'); ?>
<div class="row">
    <div class="col-lg-12">
        <div class="card b-radius--10 ">
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Name'); ?></th>
                                <th><?php echo app('translator')->get('status'); ?></th>
                                <th><?php echo app('translator')->get('Action'); ?></th>
                            </tr>
                        </thead>
                        <tbody id="categoryTable">
                           <?php $__empty_1 = true; $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                           <tr data-id="<?php echo e($item->id); ?>">
                              <td><?php echo e(__($item->name)); ?></td>
                              <td>
                                <?php
                                    echo $item->statusBadge($item->status);
                                ?>
                            </td>
                              <td>
                                 <div class="button--group">
                                    <button type="button" class="btn btn-sm btn--primary updateCategory"data-id="<?php echo e($item->id); ?>"data-name="<?php echo e($item->name); ?>" data-status="<?php echo e($item->status); ?>" data-icon="<?php echo e($item->icon); ?>"><i class="las la-edit"></i></button>
                                 </div>
                              </td>
                           </tr>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                           <tr class="empty-message">
                             <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                          </tr>
                           <?php endif; ?>
                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
            <?php if($categories->hasPages()): ?>
            <div class="card-footer py-4">
                <?php echo e(paginateLinks($categories)); ?>

            </div>
            <?php endif; ?>
        </div><!-- card end -->
    </div>
</div>



<div id="addCategory" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> <?php echo app('translator')->get('Add Category'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('admin.category.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="name"><?php echo app('translator')->get('Name'); ?>:</label>
                        <input type="text" class="form-control" name="name" placeholder="<?php echo app('translator')->get('Name'); ?>..." required>
                    </div>
                    <div class="form-group">
                        <label for="icon"><?php echo app('translator')->get('Icon'); ?>:</label>
                        <div class="input-group">
                            <input type="text" class="form-control iconPicker icon" autocomplete="off"
                            name="icon" placeholder="<?php echo app('translator')->get('Icone'); ?>..." required >
                            <span class="input-group-text  input-group-addon" data-icon="las la-home"
                                role="iconpicker">
                            </span>
                        </div>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary btn-global"><?php echo app('translator')->get('Submit'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>



<div id="updateCategory" class="modal fade" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"> <?php echo app('translator')->get('Update Category'); ?></h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('admin.category.update')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="id">
                <div class="modal-body">
                    <div class="form-group">
                        <label  for="name"> <?php echo app('translator')->get('Name'); ?>:</label>
                        <input type="text" class="form-control" name="name" placeholder="<?php echo app('translator')->get('Name'); ?>...">
                    </div>
                    <div class="form-group">
                        <label for="icon"><?php echo app('translator')->get('Icon'); ?>:</label>
                        <div class="input-group">
                            <input type="text" class="form-control iconPicker icon" autocomplete="off"
                            name="icon" placeholder="<?php echo app('translator')->get('Icone'); ?>..." required >
                            <span class="input-group-text  input-group-addon icon-preview" data-icon="las la-home"
                                role="iconpicker"></span>
                        </div>
                    </div>

                    <div class="form-group">
                        <label  for="name"> <?php echo app('translator')->get('Status'); ?>:</label>
                        <select name="status" class="form-control">
                            <option value="0" <?php echo e(@$item->status == 0 ? 'selected' : ''); ?>><?php echo app('translator')->get('Inactive'); ?></option>
                            <option value="1" <?php echo e(@$item->status == 1 ? 'selected' : ''); ?>><?php echo app('translator')->get('Active'); ?></option>

                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn--primary btn-global"><?php echo app('translator')->get('Save'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('breadcrumb-plugins'); ?>
<button type="button" class="btn btn-sm btn--primary addCategory"><i class="las la-plus"></i><?php echo app('translator')->get('Add
    New'); ?></button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
<link href="<?php echo e(asset('assets/admin/css/fontawesome-iconpicker.min.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
<script src="<?php echo e(asset('assets/admin/js/fontawesome-iconpicker.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
<script>
    
    (function($){
        "use strict";

        $('.addCategory').on('click', function() {
            $('#addCategory').modal('show');
        });

        // update modal anad existing data show
        $('.updateCategory').on('click', function() {
            var modal = $('#updateCategory');
            modal.find('input[name=id]').val($(this).data('id'));
            modal.find('input[name=name]').val($(this).data('name'));
            modal.find('input[name=icon]').val($(this).data('icon'));

            var statusValue = $(this).data('status');
            modal.find('select[name=status]').val(statusValue);

         // Update the icon preview in the span element
            var icon = $(this).data('icon');
            modal.find('.icon-preview').html(icon);

            modal.modal('show');
        });

        // icone picker
        $('.iconPicker').iconpicker().on('iconpickerSelected', function (e) {
            $(this).closest('.form-group').find('.iconpicker-input').val(`<i class="${e.iconpickerValue}"></i>`);
        });

    })(jQuery);

</script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fosterfarms/public_html/application/resources/views/admin/category/index.blade.php ENDPATH**/ ?>