<?php $__env->startSection('content'); ?>

    <!-- ==================== Product Details Here ==================== -->
    <section class="product-details-area py-80">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-8">
                    <div class="product-details-left">
                        <div class="product-details-left__content">
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active" id="home-tab-pane" role="tabpanel"
                                    aria-labelledby="home-tab" tabindex="0">
                                    <div class="product-details-left__thumb" style="background-image: url(<?php echo e(getImage(getFilePath('productThumbnail') . '/' . @$product->thumbnail)); ?>);">
                                    </div>
                                </div>
                            </div>
                            <div class="info">
                                <a href="<?php echo e($product->demo_link); ?>" target="_blank">
                                    <i class="fab fa-hive live-watch"></i>
                                    <p class="mt-3"><?php echo app('translator')->get('Live Preview'); ?> <i class="far fa-eye"></i></p>
                                </a>

                                <div class="tab-content mt-3" id="myTabContent">
                                    <?php if(!empty($productImages) && is_array($productImages)): ?>
                                        <?php $__currentLoopData = $productImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $productImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="tab-pane fade<?php echo e($index === 0 ? ' show active' : ''); ?>"
                                                id="image-tab-<?php echo e($index); ?>" role="tabpanel"
                                                aria-labelledby="image-tab-<?php echo e($index); ?>" tabindex="0">
                                                <div class="product-details-left__thumb">
                                                    <a class="image-popup"
                                                        href="<?php echo e(getImage(getFilePath('productImage') . '/' . @$productImage)); ?>">
                                                        <span><?php echo app('translator')->get('Screenshots'); ?><i class="fas fa-expand"></i></span>
                                                    </a>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <!--  -->
                        <div class="row py-4">
                            <div class="product-info">
                                <div class="product-title">
                                    <h3><?php echo e(__($product->name)); ?></h3>
                                    <ul class="social-list">
                                        <li class="social-list__item"><a href="<?php echo getProductShareLinks($product->id)['facebook']; ?>"
                                                class="social-list__link" target="_blank"><i
                                                    class="fab fa-facebook-f"></i></a> </li>
                                        <li class="social-list__item"><a href="<?php echo getProductShareLinks($product->id)['twitter']; ?>"
                                                class="social-list__link" target="_blank"> <i
                                                    class="fab fa-twitter"></i></a></li>
                                        <li class="social-list__item"><a href="<?php echo getProductShareLinks($product->id)['linkedin']; ?>"
                                                class="social-list__link" target="_blank"> <i
                                                    class="fab fa-linkedin-in"></i></a></li>
                                        <li class="social-list__item"><a href="<?php echo getProductShareLinks($product->id)['instagram']; ?>"
                                                class="social-list__link" target="_blank"> <i
                                                    class="fab fa-instagram"></i></a></li>
                                    </ul>
                                </div>
                                <div class="tag-rating-sales-wrap">
                                    <p class="cate-title"><?php echo e(__(@$product->category->name)); ?></p>
                                    <div class="ratings-box me-3">
                                        <div class="review-wrapper">
                                            <?php
                                                $averageRatingHtml = calculateAverageRating($product->average_rating);
                                                if (!empty($averageRatingHtml['ratingHtml'])) {
                                                    echo $averageRatingHtml['ratingHtml'];
                                                }
                                            ?>
                                            <p class="review-count">
                                                <?php if(empty($product->review_count && $product->average_rating)): ?>
                                                <?php else: ?>
                                                    (<?php echo e(__($product->review_count)); ?>)
                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="price">
                                        <h5 class="product-price"> <i class="fas fa-shopping-cart"></i>
                                            <?php echo e(getTotalSales($product->id)); ?> <?php echo app('translator')->get('sales'); ?></h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="row gy-4 justify-content-center">
                        <div class="col-lg-12">
                            <ul class="nav nav-tabs coustome-tabs" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home"
                                        type="button" role="tab" aria-controls="home" aria-selected="false"
                                        tabindex="-1">
                                        <?php echo app('translator')->get('Description'); ?>
                                    </a>
                                </li>

                                <li class="nav-item" role="presentation">
                                    <a class="nav-link " id="contact-tab" data-bs-toggle="tab" data-bs-target="#contact"
                                        type="button" role="tab" aria-controls="contact" aria-selected="false"
                                        tabindex="-1">
                                        <?php echo app('translator')->get('Reviews'); ?>
                                    </a>
                                </li>
                            </ul>
                            <div class="tab-content pt-4" id="myTabContent">

                                <div class="tab-pane fade active show" id="home" role="tabpanel"
                                    aria-labelledby="home-tab">
                                    <div class="row gy-4 justify-content-center">
                                        <div class="col-lg-12 col-md-12">
                                            <div class="about-right-content">
                                                <div class="section-heading mb-0 wyg">
                                                    <p class="section-heading__desc mb-4 wyg">
                                                        <?php echo $product->description; ?>
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">
                                    <div class="row gy-4 justify-content-center">
                                        <div class="col-lg-12 col-md-12">
                                            <div class="tab-review-wrap">
                                                <ul class="comment-list">
                                                    <?php $__empty_1 = true; $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <li class="comment-list__item d-flex flex-wrap">
                                                            <div class="comment-list__thumb">
                                                                <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . @$item->user->image)); ?>"
                                                                    alt="image">
                                                            </div>
                                                            <div class="comment-list__content">
                                                                <h4 class="comment-list__name"><?php echo e($item->user->username); ?>

                                                                </h4>
                                                                <div
                                                                    class="time-rating-warper d-flex justify-content-between">
                                                                    <span class="comment-list__time"> <span
                                                                            class="comment-list__time-icon"><i
                                                                                class="far fa-clock"></i></span>
                                                                        <?php echo e(diffForHumans($item->created_at)); ?> </span>
                                                                    <ul class="rating-list mb-2">
                                                                        <?php
                                                                            $averageRatingHtml = calculateAverageRating($product->average_rating);
                                                                            if (!empty($averageRatingHtml['ratingHtml'])) {
                                                                                echo $averageRatingHtml['ratingHtml'];
                                                                            }
                                                                        ?>
                                                                    </ul>
                                                                </div>
                                                                <p class="comment-list__desc"><?php echo e(__($item->message)); ?></p>
                                                                <div class="comment-list__reply">
                                                                    <a class="comment-list__reply-text"
                                                                        href="javascript:void(0)"><span
                                                                            class="comment-list__reply-icon"></span></a>
                                                                    <span><?php echo e(showDateTime($item->created_at)); ?></span>
                                                                </div>
                                                            </div>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <p><?php echo app('translator')->get('No Reviews'); ?></p>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                            <?php if($reviews->hasPages()): ?>
                                                <div class="py-4">
                                                    <?php echo e(paginateLinks($reviews)); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>

                                        <div class="row pt-3">
                                            <div class="contactus-form">
                                                <div class="account-form__content mb-4">
                                                    <h3 class="account-form__title mb-2"> <?php echo app('translator')->get('Review this product'); ?> </h3>
                                                    <p class="account-form__desc mb-2"><?php echo app('translator')->get('Your review goes here'); ?></p>
                                                </div>

                                                <form action="<?php echo e(route('user.reviews.store')); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                    <div class="row gy-3">
                                                        <div class="col-sm-12">
                                                            <div class="form-group">
                                                                <label for="message" class="form--label">
                                                                    <?php echo app('translator')->get('Message'); ?></label>
                                                                <textarea class="form--control" name="message" placeholder="<?php echo app('translator')->get('Message'); ?>" id="message"></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-12">
                                                            <div class="form-group">
                                                                <label class="form--label"> <?php echo app('translator')->get('Rating'); ?> <i
                                                                        class="fas fa-star"></i></label>
                                                                <div class="rating-stars">
                                                                    <input type="hidden" name="rating" id="rating"
                                                                        value="0">
                                                                    <i class="far fa-star" data-rating="1"></i>
                                                                    <i class="far fa-star" data-rating="2"></i>
                                                                    <i class="far fa-star" data-rating="3"></i>
                                                                    <i class="far fa-star" data-rating="4"></i>
                                                                    <i class="far fa-star" data-rating="5"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-sm-12">
                                                            <button type="submit" class="btn btn--base">
                                                                <?php echo app('translator')->get('Submit'); ?> <i class="fas fa-arrow-right"></i>
                                                                <span style="top: 40.6094px; left: 80px;"></span>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 ps-md-4">
                    <div class="row ">
                        <div class="col-lg-12">
                            <div class="product-info-right">
                                <div class="box_content">
                                    <?php if($product->is_free == 1): ?>
                                        <h5 class="text-center"><?php echo e($general->cur_sym); ?> 00.00</h5>
                                        <a class="btn btn--base outline"
                                            href="<?php echo e(route('user.product.payment', $product->id)); ?>"><i
                                                class="fas fa-cart-plus"></i> <?php echo app('translator')->get('Free'); ?>
                                        </a>
                                    <?php else: ?>
                                        <div class="price-wrapper d-flex justify-content-center">
                                            <?php if(isset($product->discount)): ?>
                                                <h5 class="me-2"><?php echo e($general->cur_sym); ?>

                                                    <?php echo e(showAmount($product->price - ($product->price * $product->discount) / 100)); ?>

                                                </h5>
                                                <h5 class="discount-price"><?php echo e($general->cur_sym); ?>

                                                    <?php echo e(showAmount($product->price)); ?>

                                                </h5>
                                            <?php else: ?>
                                                <h5 class="me-2"><?php echo e($general->cur_sym); ?>

                                                    <?php echo e(showAmount($product->price)); ?>

                                                </h5>
                                            <?php endif; ?>

                                        </div>
                                        <div class="text-center">
                                            <a class="btn btn--base outline"
                                                href="<?php echo e(route('user.product.payment', $product->id)); ?>"><i
                                                    class="fas fa-cart-plus"></i> <?php echo app('translator')->get('Buy Now'); ?>
                                            </a>
                                        </div>

                                    <?php endif; ?>

                                </div>
                                <div class="box_content">
                                    <div class="txt">
                                        <h6><?php echo app('translator')->get('Updated'); ?></h6>
                                        <p><?php echo e(showDateTime($product->updated_at)); ?></p>
                                    </div>
                                    <div class="txt">
                                        <h6><?php echo app('translator')->get('Published'); ?></h6>
                                        <p><?php echo e(showDateTime($product->created_at)); ?></p>
                                    </div>
                                </div>
                                <div class="box_content">
                                    <div class="txt">
                                        <h6><?php echo app('translator')->get('Category'); ?></h6>
                                        <p><?php echo e(__($product->category->name)); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- ==================== Product Details End ==================== -->

    <!-- ==================== Our Products Start Here ==================== -->
    <section class="echommerce-products section-bg py-80">
        <span class="circle1"></span>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-12">
                    <div class="section-heading  text-left">
                        <h2 class="section-heading__title pb-4"><?php echo app('translator')->get('Related Products'); ?></h2>
                        <div class="border-bottom pb-3"></div>
                    </div>
                </div>
            </div>
            <div class="row gy-4 justify-content-center latest-products card_wraper" id="card_wraper">
                <?php $__empty_1 = true; $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-xl-3 col-lg-4 col-md-6">
                        <div class="card_body">
                            <div class="card-img">
                                <a href="<?php echo e(route('product.details', ['slug' => slug($product->name), 'id' => $product->id])); ?>">
                                    <img src="<?php echo e(getImage(getFilePath('productThumbnail').'/'.@$product->thumbnail)); ?>" alt="product image">
                                </a>
                                <?php if(isset($product->discount)): ?>
                                <div class="product-badge bg--info">
                                    <?php if($product->is_free ==1): ?>
                                    <p><?php echo app('translator')->get('Free'); ?></p>
                                    <?php else: ?>
                                    <p><?php echo e($product->discount); ?>%</p>
                                    <?php endif; ?>
                                </div>
                                <?php else: ?>
                                <div class="product-badge bg--base">
                                    <p><?php echo app('translator')->get('New'); ?></p>
                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="content">
                                <div class="content-text">
                                    <p><a href="<?php echo e(route('filter.category.products',$product->category->id)); ?>"> <?php echo e(__($product->category->name)); ?> </a></p>
                                    <h5><a href="<?php echo e(route('product.details', ['slug' => slug($product->name), 'id' => $product->id])); ?>" target="_blank">
                                        <?php if(strlen(__($product->name)) >30): ?>
                                        <?php echo e(substr( __($product->name), 0,30).'...'); ?>

                                        <?php else: ?>
                                        <?php echo e(__($product->name)); ?>

                                        <?php endif; ?>
                                    </a></h5>
                                </div>
                                <div class="card-meta">
                                    <div class="sale">
                                        <p class="amount"><i class="fas fa-bolt"></i> <?php echo e(__($product->sale)); ?> <?php echo app('translator')->get('sales'); ?></p>
                                        <div class="review-wrapper">
                                            <?php
                                            $averageRatingHtml = calculateAverageRating($product->average_rating);
                                            if (!empty($averageRatingHtml['ratingHtml'])) {
                                                echo $averageRatingHtml['ratingHtml'];
                                            }
                                        ?>
                                        <p class="review-count">
                                            <?php if(empty($product->review_count && $product->average_rating )): ?>
                                             <?php else: ?>
                                               (<?php echo e(__( $product->review_count)); ?>)
                                             <?php endif; ?>
                                        </p>
                                        </div>
                                    </div>
                                    <div class="btm">
                                        <div class="price">
                                            <?php if($product->is_free == 1): ?>
                                            <h5 class="product-price"><?php echo e($general->cur_sym); ?> 00.00</h5>
                                            <?php else: ?>
                                            <h5 class="product-price"><?php echo e($general->cur_sym); ?> <?php echo e(showAmount($product->price)); ?></h5>
                                            <?php endif; ?>
                                        </div>
                                        <div class="cart">
                                            <?php if($product->is_free == 1): ?>
                                            <a href="<?php echo e(route('product.details', ['slug' => slug($product->name), 'id' => $product->id])); ?>" class="btn btn--base btn--sm outline"><i class="fas fa-cart-plus"></i> <?php echo app('translator')->get('Free'); ?></a>
                                            <?php else: ?>
                                            <a href="<?php echo e(route('user.product.payment',$product->id)); ?>" class="btn btn--base btn--sm"><i class="fas fa-cart-plus"></i> <?php echo app('translator')->get('Purchase'); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p><?php echo e(__($emptyMessage)); ?></p>
                <?php endif; ?>

            </div>
        </div>
        <span class="circle2"></span>
    </section>
    <!-- ==================== / Our Products  ==================== -->
<?php $__env->stopSection(); ?>


<?php $__env->startPush('style'); ?>
    <style>
        .wyg h1,
        .wyg h2,
        .wyg h3,
        .wyg h4 {
            color: hsl(var(--black));
        }

        .wyg p {
            color: hsl(var(--black));
        }

        .wyg ul {
            margin: 35px;
        }

        .wyg ul li {
            list-style-type: disc;
            color: hsl(var(--black));
            font-family: var(--body-font);
        }

        /*========= dark css =======*/
        .dark .wyg h1,
        .dark .wyg h2,
        .dark .wyg h3,
        .dark .wyg h4 {
            color: hsl(var(--white)/.6);
        }

        .dark .wyg p {
            color: hsl(var(--white)/.6);
        }

        .dark .wyg ul {
            margin: 35px;
        }

        .dark .wyg ul li {
            list-style-type: disc;
            color: hsl(var(--white));
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        
        // rating set
        $(document).ready(function() {
            "use strict"
            $('.rating-stars i').on('click', function() {
                var rating = parseInt($(this).data('rating'));
                $('#rating').val(rating);
                updateStars(rating);
            });

            $('#rating').on('input', function() {
                var rating = $(this).val();
                updateStars(rating);
            });


            function updateStars(rating) {
                var stars = $('.rating-stars i');
                stars.removeClass('fas').addClass('far');
                stars.each(function(index) {
                    if (index < rating) {
                        $(this).removeClass('far').addClass('fas');
                    }
                });
            }

            var initialRating = parseInt($('#rating').val());
            if (initialRating > 0) {
                updateStars(initialRating);
            }

        });
        // end rating set
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fosterfarms/public_html/application/resources/views/presets/default/shop/product_details.blade.php ENDPATH**/ ?>