<?php
    $contact = getContent('contact_us.content', true);
    $socialIcons = getContent('social_icon.element', false);
    $languages = App\Models\Language::all();
    $pages = App\Models\Page::where('tempname', $activeTemplate)->get();
    $user = auth()->user();
?>
<!--========================== Header section Start ==========================-->
<div class="header-main-area">
    <div class="header-top">
        <div class="container">
            <div class="row">
                <div class="top-header-wrapper">
                    <div class="top-contact">
                        <ul class="login-registration-list">
                            <li class="login-registration-list__item">
                                <ul class="social-list">
                                    <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="social-list__item"><a href="<?php echo e(__($item->data_values->url)); ?>"
                                                class="social-list__link" target="_blank"><?php echo $item->data_values->social_icon ?></a> </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </li>
                        </ul>
                    </div>
                    <div class="top-button">
                        <ul class="login-registration-list d-flex flex-wrap justify-content-between align-items-center">
                            <?php if(auth()->guard()->check()): ?>
                                <li class="login-registration-list__item"><span
                                        class="login-registration-list__icon"></span><a href="<?php echo e(route('user.logout')); ?>"
                                        class="login-registration-list__link"><i
                                            class="fas fa-sign-out-alt"></i><?php echo app('translator')->get('Logout'); ?></a></li>
                            <?php else: ?>
                                <li class="login-registration-list__item"><span
                                        class="login-registration-list__icon"></span><a href="<?php echo e(route('user.login')); ?>"
                                        class="login-registration-list__link"><i
                                            class="fas fa-sign-in-alt"></i><?php echo app('translator')->get('Login'); ?></a></li>
                                <li class="login-registration-list__item"><span
                                        class="login-registration-list__icon"></span><a href="<?php echo e(route('user.register')); ?>"
                                        class="login-registration-list__link"><i class="fas fa-user-plus"></i><?php echo app('translator')->get('Register'); ?></a></li>
                            <?php endif; ?>
                        </ul>
                        <div class="language-box">
                            <select class="langSel select">
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($language->code); ?>"
                                        <?php if(Session::get('lang') === $language->code): ?> selected <?php endif; ?>><?php echo e(__($language->name)); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="header" id="header">
        <div class="container position-relative">
            <div class="row">
                <div class="header-wrapper">
                    <!-- ham menu -->
                    <i class="fas fa-bars ham__menu" data-bs-toggle="offcanvas" data-bs-target="#offcanvasExample"
                        aria-controls="offcanvasExample"></i>

                    <!-- logo -->
                    <div class="header-menu-wrapper align-items-center d-flex">
                        <div class="logo-wrapper">
                            <a href="<?php echo e(route('home')); ?>" class="normal-logo"> <img
                                    src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png', '?' . time())); ?>"
                                    alt="<?php echo e(config('app.name')); ?>"></a>

                            <a href="<?php echo e(route('home')); ?>" class="dark-logo hidden"> <img
                                    src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo_white.png', '?' . time())); ?>"
                                    alt="<?php echo e(config('app.name')); ?>"></a>
                        </div>
                    </div>
                    <!-- / logo -->

                    <div class="menu-wrapper">
                        <ul class="main-menu">
                            <?php if(auth()->guard()->check()): ?>
                                <li>
                                    <a class="<?php echo e(Route::is('user.home') ? 'active' : ''); ?>" aria-current="page"
                                        href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                                </li>
                            <?php endif; ?>
                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($page->slug != 'blog'): ?>
                                    <li><a class="<?php echo e(Request::url() == url('/') . '/' . $page->slug ? 'active' : ''); ?>"
                                            aria-current="page"
                                            href="<?php echo e(route('pages', [$page->slug])); ?>"><?php echo e(__($page->name)); ?></a>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <div class="menu-right-wrapper">
                            <ul>
                                <li>
                                    <div class="light-dark-btn-wrap ms-1" id="light-dark-checkbox">
                                        <i class="fas fa-moon mon-icon"></i>
                                        <i class='fas fa-sun sun-icon'></i>
                                    </div>
                                </li>
                                <li></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!--========================== Header section End ==========================-->

<!--========================== Sidebar mobile menu wrap Start ==========================-->


<div class="offcanvas offcanvas-start text-bg-light" tabindex="-1" id="offcanvasExample">
    <div class="offcanvas-header">
        <div class="logo">
            <div class="header-menu-wrapper align-items-center d-flex">
                <div class="logo-wrapper">
                    <a href="<?php echo e(route('home')); ?>" class="normal-logo"> <img
                            src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo.png', '?' . time())); ?>"
                            alt="<?php echo e(config('app.name')); ?>"></a>
                    <a href="<?php echo e(route('home')); ?>" class="dark-logo hidden"> <img
                            src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo_white.png', '?' . time())); ?>"
                            alt="<?php echo e(config('app.name')); ?>"></a>
                </div>
            </div>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <?php if(auth()->guard()->check()): ?>
            <div class="user-info"
                style="background: url(<?php echo e(asset($activeTemplateTrue . 'images/sidenav_uer.jpg')); ?>);background-position: center;background-size: cover; filter: grayscale(30%) ;">
                <div class="user-thumb">
                    <img src="<?php echo e(getImage(getFilePath('userProfile') . '/' . $user->image, getFileSize('userProfile'))); ?>"
                        alt="user-image">
                </div>
                <h4 class="text-white"><?php echo e(__($user->fullname)); ?></h4>
            </div>
        <?php endif; ?>

        <ul class="side-Nav">
            <?php if(auth()->guard()->check()): ?>
                <li class="<?php echo e(Route::is('user.home') ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                </li>
            <?php endif; ?>
            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="<?php echo e(Request::url() == url('/') . '/' . $page->slug ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('pages', [$page->slug])); ?>"> <?php echo e(__($page->name)); ?></a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php if(auth()->guard()->check()): ?>
                <li>
                    <a href="<?php echo e(route('user.logout')); ?>"><?php echo app('translator')->get('Logout'); ?></a>
                </li>
            <?php else: ?>
                <li class="<?php echo e(Route::is('user.login') ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login'); ?></a>
                </li>
                <li class="<?php echo e(Route::is('user.register') ? 'active' : ''); ?>">
                    <a href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Register'); ?></a>
                </li>
            <?php endif; ?>
        </ul>

    </div>
</div>
<?php /**PATH /home/fosterfarms/public_html/application/resources/views/presets/default/components/header.blade.php ENDPATH**/ ?>