<div class="row gy-4 justify-content-center">
    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="col-xl-4 col-lg-6 col-md-4" >
        <div class="card_body">
            <div class="card-img">
                <a href="<?php echo e(route('product.details', ['slug' => slug($product->name), 'id' => $product->id])); ?>">
                    <img src="<?php echo e(getImage(getFilePath('productThumbnail').'/'.@$product->thumbnail)); ?>" alt="product image">
                </a>
                <?php if(isset($product->discount)): ?>
                <div class="product-badge bg--info">
                    <?php if($product->is_free ==1): ?>
                    <p><?php echo app('translator')->get('Free'); ?></p>
                    <?php else: ?>
                    <p><?php echo e($product->discount); ?>%</p>
                    <?php endif; ?>
                </div>
                <?php else: ?>
                <div class="product-badge bg--base">
                    <p><?php echo app('translator')->get('New'); ?></p>
                </div>
                <?php endif; ?>
            </div>
            <div class="content">
                <div class="content-text">
                    <p><a href="<?php echo e(route('filter.category.products',$product->category->id)); ?>"> <?php echo e(__($product->category->name)); ?> </a></p>
                    <h5><a href="<?php echo e(route('product.details', ['slug' => slug($product->name), 'id' => $product->id])); ?>" target="_blank">
                        <?php if(strlen(__($product->name)) >30): ?>
                        <?php echo e(substr( __($product->name), 0,30).'...'); ?>

                        <?php else: ?>
                        <?php echo e(__($product->name)); ?>

                        <?php endif; ?>
                    </a></h5>
                </div>
                <div class="card-meta">
                    <div class="sale">
                        <p class="amount"><i class="fas fa-bolt"></i> <?php echo e(__($product->sale)); ?> <?php echo app('translator')->get('sales'); ?></p>
                        <div class="review-wrapper">
                            <?php
                            $averageRatingHtml = calculateAverageRating($product->average_rating);
                            if (!empty($averageRatingHtml['ratingHtml'])) {
                                echo $averageRatingHtml['ratingHtml'];
                            }
                        ?>
                        <p class="review-count">
                            <?php if(empty($product->review_count && $product->average_rating )): ?>
                             <?php else: ?>
                               (<?php echo e(__( $product->review_count)); ?>)
                             <?php endif; ?>
                        </p>
                        </div>
                    </div>
                    <div class="btm">
                        <div class="price">
                            <?php if($product->is_free == 1): ?>
                            <h5 class="product-price"><?php echo e($general->cur_sym); ?> 00.00</h5>
                            <?php else: ?>
                            <h5 class="product-price"><?php echo e($general->cur_sym); ?> <?php echo e(showAmount($product->price)); ?></h5>
                            <?php endif; ?>
                        </div>
                        <div class="cart">
                            <?php if($product->is_free == 1): ?>
                            <a href="<?php echo e(route('product.details', ['slug' => slug($product->name), 'id' => $product->id])); ?>" class="btn btn--base btn--sm outline"><i class="fas fa-cart-plus"></i> <?php echo app('translator')->get('Free'); ?></a>
                            <?php else: ?>
                            <a href="<?php echo e(route('user.product.payment',$product->id)); ?>" class="btn btn--base btn--sm"><i class="fas fa-cart-plus"></i> <?php echo app('translator')->get('Purchase'); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <p class="text-center"><?php echo e(__($emptyMessage)); ?></p>
    <?php endif; ?>
</div>
<?php /**PATH /home/fosterfarms/public_html/application/resources/views/presets/default/shop/filtered_search.blade.php ENDPATH**/ ?>