<?php
$discountShop = getContent('discount_shop.content',true);
$discountProducts = App\Models\Product::where('status',1)
->with(['productImages','category'])
->where('discount', '>', 0)
->latest()
->limit(8)
->get();
?>
<!-- ========  new item section ===== -->
<section class="new-section pt-120" id="discount">
    <div class="container" >
        <div class="row justify-content-left text-left">
            <div class="col-xl-7 col-lg-8 hero-content">
                <h2><?php echo e(__($discountShop->data_values->heading)); ?></h2>
            </div>
        </div>
        <div class="row justify-content-center pt-5 gy-4 new-product-card_wraper">
              <!-- card  -->
            <?php $__currentLoopData = $discountProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-md-4 col-sm-6" >
                    <div class="product-container align-items-center">
                        <p class="product-discount-badge">
                            <?php echo e($product->discount); ?>%
                        </p>
                        <div class="thumb">
                            <a href="<?php echo e(route('product.details', ['slug' => slug($product->name), 'id' => $product->id])); ?>">
                                <img src="<?php echo e(getImage(getFilePath('productThumbnail').'/'.@$product->thumbnail)); ?>" alt="product Image">
                            </a>
                        </div>
                        <div class="product-card-body">
                            <div class="card-text_content">
                                <h6 class="product-title"><a href="<?php echo e(route('product.details', ['slug' => slug($product->name), 'id' => $product->id])); ?>" title="<?php echo e($product->name); ?>">
                                    <?php if(strlen(__($product->name)) >10): ?>
                                        <?php echo e(substr( __($product->name), 0, 28).'...'); ?>

                                        <?php else: ?>
                                        <?php echo e(__($product->name)); ?>

                                        <?php endif; ?>
                                </a></h6>
                                <?php
                                $averageRatingHtml = calculateAverageRating($product->average_rating);
                                if (!empty($averageRatingHtml['ratingHtml'])) {
                                    echo $averageRatingHtml['ratingHtml'];
                                }
                            ?>
                            </div>

                            <div class="product-meta">
                                <?php if($product->is_free ==1): ?>
                                <p><?php echo e($general->cur_sym); ?> 00.00</p>
                                <?php else: ?>
                                <p><?php echo e($general->cur_sym); ?><span class="text-decoration-line-through"><?php echo e(showAmount($product->price)); ?></span> <?php echo e($general->cur_sym); ?><?php echo e(showAmount($product->price) * (100 - $product->discount)/100); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <!-- / product card  -->
            <div class="pt-4 text-center">
                <a href="<?php echo e(route('browse')); ?>" class="btn btn--base "><?php echo app('translator')->get('View More'); ?></a>
            </div>
        </div>
    </div>
</section>
<!-- ======== / new item section ===== -->
<?php /**PATH /home/fosterfarms/public_html/application/resources/views/presets/default/sections/discount_shop.blade.php ENDPATH**/ ?>