<?php $__env->startSection('panel'); ?>
<div class="row mb-none-30 justify-content-center">
    <div class="col-xl-12 col-md-12 mb-30">
        <div class="card b-radius--10 overflow-hidden box--shadow1">
            <div class="card-body">
                <h5 class="mb-20 p-2 text-muted"><?php echo app('translator')->get('Shipping Address'); ?></h5>
                <ul class="list-group">
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <?php echo app('translator')->get('Order Number'); ?>
                        <span class="fw-bold  badge badge--success">#<?php echo e(__(@$orderDetails->order_number)); ?></span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <?php echo app('translator')->get('Full Name'); ?>
                        <span class="fw-bold"><?php echo e(__(@$orderDetails->firstname.@$orderDetails->lastname)); ?></span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <?php echo app('translator')->get('Address'); ?>
                        <span class="fw-bold"><?php echo e(__(@$orderDetails->address)); ?></span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <?php echo app('translator')->get('Email'); ?>
                        <span class="fw-bold">
                            <a><?php echo e(__(@$orderDetails->email)); ?></a>
                        </span>
                    </li>
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <?php echo app('translator')->get('Phone Number'); ?>
                        <span class="fw-bold"><?php echo e(__(@$orderDetails->phone)); ?></span>
                    </li>
                </ul>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive--sm table-responsive">
                    <table class="table table--light style--two custom-data-table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Product Image'); ?></th>
                                <th><?php echo app('translator')->get('Product Name'); ?></th>
                                <th><?php echo app('translator')->get('Quantity'); ?></th>
                                <th><?php echo app('translator')->get('Total Price'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                           <?php $__empty_1 = true; $__currentLoopData = $orderDetails->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                           <tr>
                              <td><img src="<?php echo e(getImage(getFilePath('productImage').'/'.@$item->productImages[0]->image)); ?>" alt="Image" class="rounded" style="width:50px;"></td>

                              <td>
                                <?php echo e(__($item->name)); ?>

                            </td>
                            <td>
                                <?php echo e(__($item->pivot->product_quantity)); ?> x <?php echo e(showAmount(__($item->price))); ?>

                            </td>
                            <td>
                                <?php echo e(__($general->cur_sym)); ?><?php echo e(__($item->price * $item->pivot->product_quantity)); ?>

                            </td>
                           </tr>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                           <tr>
                             <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                          </tr>
                           <?php endif; ?>
                        </tbody>
                    </table><!-- table end -->
                </div>
            </div>
        </div>
    </div>
  

</div>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fosterfarms/public_html/application/resources/views/admin/orders/order_details.blade.php ENDPATH**/ ?>