<?php
    $blog = getContent('blog.content', true);
    $blogElements = getContent('blog.element', false, 3);
?>
<!-- News Section -->
<section class="news-section py-120 section-bg">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-7 col-lg-8 text-center hero-content">
                <h2 class="pb-40"><?php echo e(__($blog->data_values->heading)); ?></h2>
                <p class="pb-80"><?php echo e(__($blog->data_values->sub_heading)); ?></p>
            </div>
        </div>
        <div class="row pt-1 gy-5 nws-card_wraper justify-content-center">
            <?php $__currentLoopData = $blogElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="nws-card_body">
                        <div class="card-img">
                            <a
                                href="<?php echo e(route('blog.details', ['slug' => slug($item->data_values->title), 'id' => $item->id])); ?>">
                                <img src="<?php echo e(getImage(getFilePath('blog') . '/' . 'thumb_' . $item->data_values->blog_image)); ?>"
                                    alt="blog image">
                            </a>
                        </div>
                        <div class="card-item">
                            <div class="date">
                                <p><?php echo e(showDateTime($item->created_at)); ?></p>
                            </div>
                            <div class="nws-title pt-3">
                                <a
                                    href="<?php echo e(route('blog.details', ['slug' => slug($item->data_values->title), 'id' => $item->id])); ?>">
                                    <h4>
                                        <?php if(strlen(__($item->data_values->title)) > 50): ?>
                                            <?php echo e(substr(__($item->data_values->title), 0, 50) . '...'); ?>

                                        <?php else: ?>
                                            <?php echo e(__($item->data_values->title)); ?>

                                        <?php endif; ?>
                                    </h4>
                                </a>
                            </div>

                            <div class="py-2">
                                <a href="<?php echo e(route('blog.details', ['slug' => slug($item->data_values->title), 'id' => $item->id])); ?>"
                                    class="btn btn--base"><?php echo e(__($item->data_values->blog_btn)); ?> <i
                                        class="fas fa-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<!-- /News Section -->
<?php /**PATH /home/fosterfarms/public_html/application/resources/views/presets/default/sections/blog.blade.php ENDPATH**/ ?>